local t = Def.ActorFrame {};
-- Header bits
t[#t+1] = Def.ActorFrame {
	OnCommand=function(self)
		self:addx(-SCREEN_WIDTH):decelerate(0.6):addx(SCREEN_WIDTH)
	end;	
	OffCommand=function(self)
		self:decelerate(0.6):addx(-SCREEN_WIDTH)
	end;
	Def.Sprite {
		Texture="_underlay";
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X-320):y(SCREEN_TOP):horizalign(left):vertalign(top)
		end;
	};	
	Def.Sprite {
		Texture="_icon";
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X-302):y(SCREEN_TOP+31):horizalign(left):vertalign(middle)
		end;
		OffCommand=function(self) self:linear(0.1):diffusealpha(0) end;
	};	
	LoadFont("_exo 2 32px") .. {
		Name="HeaderText";
		Text=string.upper(Screen.String("HeaderText"));
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X-302+42):y(SCREEN_TOP+20):horizalign(left):vertalign(top):zoom(0.75):maxwidth(SCREEN_WIDTH*0.65)
			self:diffuse(color("#26BF99"))
		end;
		OffCommand=function(self) self:sleep(0.05):linear(0.1):diffusealpha(0) end;
		UpdateScreenHeaderMessageCommand=function(self,param)
			self:settext(param.Header);
		end;
	};
};
return t